namespace MSPetShopOrdersClasses {
    using System;
    using System.ComponentModel;
    using System.Collections;
    using Borland.Eco.Services;
    using Borland.Eco.ObjectRepresentation;
    using Borland.Eco.ObjectImplementation;
    using Borland.Eco.UmlRt;
    using Borland.Eco.UmlCodeAttributes;

	[UmlCollection(typeof(OrderStatus))]
	public interface IOrderStatusList : ICollection
	{
		#region ECO generated code
		OrderStatus this[int index]
		{
			get;
			set;
		}
		int Add(OrderStatus value);
		bool Contains(OrderStatus value);
		int IndexOf(OrderStatus value);
		void Insert(int index, OrderStatus value);
		void Remove(OrderStatus value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(LineItem))]
	public interface ILineItemList : ICollection
	{
		#region ECO generated code
		LineItem this[int index]
		{
			get;
			set;
		}
		int Add(LineItem value);
		bool Contains(LineItem value);
		int IndexOf(LineItem value);
		void Insert(int index, LineItem value);
		void Remove(LineItem value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Order))]
	public interface IOrderList : ICollection
	{
		#region ECO generated code
		Order this[int index]
		{
			get;
			set;
		}
		int Add(Order value);
		bool Contains(Order value);
		int IndexOf(Order value);
		void Insert(int index, Order value);
		void Remove(Order value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="04979df4-2508-48d0-994e-f60c97a33a53")]
	[UmlMetaAttribute("ownedElement", typeof(LineItem))]
	[UmlMetaAttribute("ownedElement", typeof(Order))]
	[EcoCodeGenVersion("2.0")]
	[UmlMetaAttribute("ownedElement", typeof(OrderStatus))]
    public class MSPetShopOrdersClassesPackage {

        [UmlElement("Association", Id="f5666bb3-e3cf-4982-b2eb-fb06f379062f")]
		public class OrderLineItem
		{
		}

        [UmlElement("Association", Id="5a2e0bc3-b4d5-482b-a850-f2ab4d3adb6e")]
		public class OrderOrderStatus
		{
		}
    }
    [UmlElement(Id="37a20077-c100-4146-b541-c43aabc7eb9e")]
    public class LineItem : ILoopBack {

        public class LineItemListAdapter : ObjectListAdapter, ILineItemList
		{
			public LineItemListAdapter(IList source) : 
					base(source)
			{
			}
			public LineItem this[int index]
			{
				get
				{
					return ((LineItem)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(LineItem value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(LineItem value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(LineItem value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, LineItem value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(LineItem value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public LineItem(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 5);
			public const int Quantity = Eco_FirstMember;
			public const int UnitPrice = (Quantity + 1);
			public const int ItemId = (UnitPrice + 1);
			public const int LineNum = (ItemId + 1);
			public const int Order = (LineNum + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public LineItem(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Order, Id="47ca18f6-fdba-4b16-aae2-d5a07d6a18bf")]
		[UmlMetaAttribute("association", typeof(MSPetShopOrdersClassesPackage.OrderLineItem), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Order Order
		{
			get
			{
				return ((Order)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Order)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Order, ((object)(value)));
			}
		}
		[UmlElement(Id="936ce76c-f088-4202-9adc-286e72c94469", Index=Eco_LoopbackIndices.LineNum)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public int LineNum
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LineNum)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LineNum, ((object)(value)));
			}
		}
		[UmlElement(Id="8fa5853c-5f3a-405b-8621-0aea898d5ab2", Index=Eco_LoopbackIndices.ItemId)]
		public string ItemId
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ItemId)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ItemId, ((object)(value)));
			}
		}
		[UmlElement(Id="19caea61-73e1-4246-be6b-71478339c221", Index=Eco_LoopbackIndices.Quantity)]
		public int Quantity
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Quantity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Quantity, ((object)(value)));
			}
		}
		[UmlElement(Id="40075f48-0e00-41e0-8c33-7b749d8d8ab1", Index=Eco_LoopbackIndices.UnitPrice)]
		public decimal UnitPrice
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitPrice)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitPrice, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="d3598331-83a1-4b86-aab9-54c14d16960a")]
    public class Order : ILoopBack {

        public class OrderListAdapter : ObjectListAdapter, IOrderList
		{
			public OrderListAdapter(IList source) : 
					base(source)
			{
			}
			public Order this[int index]
			{
				get
				{
					return ((Order)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Order value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Order value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Order value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Order value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Order value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Order(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 27);
			public const int ShipToLastName = Eco_FirstMember;
			public const int BillToLastName = (ShipToLastName + 1);
			public const int ShipCity = (BillToLastName + 1);
			public const int OrderDate = (ShipCity + 1);
			public const int BillCountry = (OrderDate + 1);
			public const int Courier = (BillCountry + 1);
			public const int ShipState = (Courier + 1);
			public const int ShipAddr2 = (ShipState + 1);
			public const int BillAddr1 = (ShipAddr2 + 1);
			public const int Locale = (BillAddr1 + 1);
			public const int Id = (Locale + 1);
			public const int BillAddr2 = (Id + 1);
			public const int ShipToFirstName = (BillAddr2 + 1);
			public const int ExprDate = (ShipToFirstName + 1);
			public const int BillState = (ExprDate + 1);
			public const int BillZip = (BillState + 1);
			public const int ShipCountry = (BillZip + 1);
			public const int ShipAddr1 = (ShipCountry + 1);
			public const int CreditCard = (ShipAddr1 + 1);
			public const int BillCity = (CreditCard + 1);
			public const int UserId = (BillCity + 1);
			public const int BillToFirstName = (UserId + 1);
			public const int ShipZip = (BillToFirstName + 1);
			public const int TotalPrice = (ShipZip + 1);
			public const int CardType = (TotalPrice + 1);
			public const int OrderStatus = (CardType + 1);
			public const int LineItems = (OrderStatus + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Order(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="736370dd-225d-4f58-8ca0-74212830e61a", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "DbAssign")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.LineItems, Id="52451e46-7431-472c-b44e-7d0562ad3514")]
		[UmlMetaAttribute("association", typeof(MSPetShopOrdersClassesPackage.OrderLineItem), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public ILineItemList LineItems
		{
			get
			{
				return new LineItem.LineItemListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LineItems))));
			}
		}
		[UmlElement(Id="de1affb7-7839-4cea-b86f-4cc0c0a028f9", Index=Eco_LoopbackIndices.UserId)]
		public string UserId
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UserId)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UserId, ((object)(value)));
			}
		}
		[UmlElement(Id="23273939-a1fe-4fff-8526-f30d8da2b71f", Index=Eco_LoopbackIndices.OrderDate)]
		public DateTime OrderDate
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.OrderDate, ((object)(value)));
			}
		}
		[UmlElement(Id="b81ebd6a-626b-4521-ac1a-b599d243c23a", Index=Eco_LoopbackIndices.ShipAddr1)]
		public string ShipAddr1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipAddr1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipAddr1, ((object)(value)));
			}
		}
		[UmlElement(Id="63f4fc09-06ac-467a-8166-e8c3081d5035", Index=Eco_LoopbackIndices.ShipAddr2)]
		public string ShipAddr2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipAddr2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipAddr2, ((object)(value)));
			}
		}
		[UmlElement(Id="18f6df34-6e0d-44f7-a732-51f8ed43d771", Index=Eco_LoopbackIndices.ShipCity)]
		public string ShipCity
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipCity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipCity, ((object)(value)));
			}
		}
		[UmlElement(Id="5999adad-4e9a-4826-b415-d6f9475c6e44", Index=Eco_LoopbackIndices.ShipState)]
		public string ShipState
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipState)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipState, ((object)(value)));
			}
		}
		[UmlElement(Id="eda15c7a-601f-43c7-acb5-bfc66bb6ac44", Index=Eco_LoopbackIndices.ShipZip)]
		public string ShipZip
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipZip)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipZip, ((object)(value)));
			}
		}
		[UmlElement(Id="b593be08-f9f9-4235-8ecb-f188d6ee9196", Index=Eco_LoopbackIndices.ShipCountry)]
		public string ShipCountry
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipCountry)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipCountry, ((object)(value)));
			}
		}
		[UmlElement(Id="6a2e2adc-6eef-4899-8e43-121b5cd96a1c", Index=Eco_LoopbackIndices.BillAddr1)]
		public string BillAddr1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillAddr1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillAddr1, ((object)(value)));
			}
		}
		[UmlElement(Id="73899fb8-6376-44ec-8ad7-2b52ff054cd1", Index=Eco_LoopbackIndices.BillAddr2)]
		public string BillAddr2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillAddr2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillAddr2, ((object)(value)));
			}
		}
		[UmlElement(Id="d1ac260d-c1f3-4987-b10f-c710e96ac458", Index=Eco_LoopbackIndices.BillCity)]
		public string BillCity
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillCity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillCity, ((object)(value)));
			}
		}
		[UmlElement(Id="a7c841e1-7a30-4bda-98ea-32b635f32ec5", Index=Eco_LoopbackIndices.BillState)]
		public string BillState
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillState)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillState, ((object)(value)));
			}
		}
		[UmlElement(Id="ac77acb6-7787-4d5f-992c-7edf1fbf3baa", Index=Eco_LoopbackIndices.BillZip)]
		public string BillZip
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillZip)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillZip, ((object)(value)));
			}
		}
		[UmlElement(Id="2868fab1-9fc7-44d2-bfd0-7b049f0bf4b4", Index=Eco_LoopbackIndices.BillCountry)]
		public string BillCountry
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillCountry)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillCountry, ((object)(value)));
			}
		}
		[UmlElement(Id="3cc4f677-4d00-499e-b9f2-59a944c0fe7b", Index=Eco_LoopbackIndices.Courier)]
		public string Courier
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Courier)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Courier, ((object)(value)));
			}
		}
		[UmlElement(Id="f7386119-eb4c-411e-bfef-7bd00a7fae93", Index=Eco_LoopbackIndices.TotalPrice)]
		public decimal TotalPrice
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.TotalPrice)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.TotalPrice, ((object)(value)));
			}
		}
		[UmlElement(Id="ec681b9a-215b-4947-9eab-74ff8414371e", Index=Eco_LoopbackIndices.BillToFirstName)]
		public string BillToFirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillToFirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillToFirstName, ((object)(value)));
			}
		}
		[UmlElement(Id="0ec968e3-c173-4c10-8935-b71e6f3b4d7a", Index=Eco_LoopbackIndices.BillToLastName)]
		public string BillToLastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillToLastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillToLastName, ((object)(value)));
			}
		}
		[UmlElement(Id="86f94c87-b31f-4236-8d6e-3e2fcb07cb2d", Index=Eco_LoopbackIndices.ShipToFirstName)]
		public string ShipToFirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipToFirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipToFirstName, ((object)(value)));
			}
		}
		[UmlElement(Id="06259247-558e-46b5-a94c-44cf30eecb2a", Index=Eco_LoopbackIndices.ShipToLastName)]
		public string ShipToLastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShipToLastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShipToLastName, ((object)(value)));
			}
		}
		[UmlElement(Id="c8f47d7d-0016-456e-80b5-7df3151a8292", Index=Eco_LoopbackIndices.CreditCard)]
		public string CreditCard
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CreditCard)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CreditCard, ((object)(value)));
			}
		}
		[UmlElement(Id="8a184c28-f503-4e66-a35a-9518f765451d", Index=Eco_LoopbackIndices.ExprDate)]
		public string ExprDate
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ExprDate)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ExprDate, ((object)(value)));
			}
		}
		[UmlElement(Id="f9dfc189-f3ea-4e35-b23c-2e95fc975789", Index=Eco_LoopbackIndices.CardType)]
		public string CardType
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CardType)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CardType, ((object)(value)));
			}
		}
		[UmlElement(Id="6df2ea83-efd7-464e-bed4-6353903ff446", Index=Eco_LoopbackIndices.Locale)]
		public string Locale
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Locale)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Locale, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.OrderStatus, Id="4d927097-71f5-4a3f-a95a-29972bee4880")]
		[UmlMetaAttribute("association", typeof(MSPetShopOrdersClassesPackage.OrderOrderStatus), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IOrderStatusList OrderStatus
		{
			get
			{
				return new OrderStatus.OrderStatusListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderStatus))));
			}
		}
    }
    [UmlElement(Id="500ca02d-2a58-413a-bada-c65bcc5ce359")]
    public class OrderStatus : ILoopBack {
		
		public class OrderStatusListAdapter : ObjectListAdapter, IOrderStatusList
		{
			public OrderStatusListAdapter(IList source) : 
					base(source)
			{
			}
			public OrderStatus this[int index]
			{
				get
				{
					return ((OrderStatus)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(OrderStatus value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(OrderStatus value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(OrderStatus value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, OrderStatus value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(OrderStatus value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public OrderStatus(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int Status = Eco_FirstMember;
			public const int LineNum = (Status + 1);
			public const int Timestamp = (LineNum + 1);
			public const int Order = (Timestamp + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public OrderStatus(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Order, Id="a7c15dcd-89b6-472f-ae26-e93ee0f60556")]
		[UmlMetaAttribute("association", typeof(MSPetShopOrdersClassesPackage.OrderOrderStatus), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Order Order
		{
			get
			{
				return ((Order)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Order)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Order, ((object)(value)));
			}
		}
		[UmlElement(Id="1d77560d-c7fd-4ff3-91aa-f18f79e212ff", Index=Eco_LoopbackIndices.LineNum)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public int LineNum
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LineNum)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LineNum, ((object)(value)));
			}
		}
		[UmlElement(Id="b25111b0-c217-420b-a233-da95b53d0d82", Index=Eco_LoopbackIndices.Timestamp)]
		public DateTime Timestamp
		{
			get
			{
				return ((DateTime)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Timestamp)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Timestamp, ((object)(value)));
			}
		}
		[UmlElement(Id="13f319ec-8a53-43d3-a332-f3941f9588d4", Index=Eco_LoopbackIndices.Status)]
		public string Status
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Status)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Status, ((object)(value)));
			}
		}
    }
}
